<?php if (isset($component)) { $__componentOriginal8c0e86a062c1c5bb6d0e151b7076f3fd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8c0e86a062c1c5bb6d0e151b7076f3fd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.public','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.public'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> Blog - Últimas Publicaciones <?php $__env->endSlot(); ?>

    <!-- Hero Section -->
    <div class="bg-gradient-to-r from-blue-600 to-purple-600 text-white py-16">
        <div class="container mx-auto px-4">
            <div class="text-center">
                <h1 class="text-4xl md:text-6xl font-bold mb-4">Nuestro Blog</h1>
                <p class="text-xl md:text-2xl opacity-90">Descubre las últimas noticias y artículos</p>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 py-12">
        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Sidebar con filtros -->
            <aside class="lg:w-1/4">
                <div class="bg-white rounded-lg shadow-lg p-6 sticky top-4">
                    <h3 class="text-xl font-bold mb-6 text-gray-800">Filtros</h3>

                    <form method="GET" action="<?php echo e(route('posts.index')); ?>" class="space-y-6">
                        <!-- Búsqueda -->
                        <div>
                            <label for="search" class="block text-sm font-medium text-gray-700 mb-2">
                                Buscar
                            </label>
                            <div class="relative">
                                <input
                                    type="text"
                                    id="search"
                                    name="search"
                                    value="<?php echo e(request('search')); ?>"
                                    placeholder="Buscar artículos..."
                                    class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                >
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>

                        <!-- Categorías -->
                        <div>
                            <label for="category" class="block text-sm font-medium text-gray-700 mb-2">
                                Categoría
                            </label>
                            <select
                                name="category"
                                id="category"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                            >
                                <option value="">Todas las categorías</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                        value="<?php echo e($category->id); ?>"
                                        <?php echo e(request('category') == $category->id ? 'selected' : ''); ?>

                                    >
                                        <?php echo e($category->name); ?> (<?php echo e($category->posts_count); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Etiquetas -->
                        <div>
                            <label for="tag" class="block text-sm font-medium text-gray-700 mb-2">
                                Etiqueta
                            </label>
                            <select
                                name="tag"
                                id="tag"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                            >
                                <option value="">Todas las etiquetas</option>
                                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                        value="<?php echo e($tag->id); ?>"
                                        <?php echo e(request('tag') == $tag->id ? 'selected' : ''); ?>

                                    >
                                        <?php echo e($tag->name); ?> (<?php echo e($tag->posts_count); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="flex gap-2">
                            <button
                                type="submit"
                                class="flex-1 bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors duration-200 font-medium"
                            >
                                Filtrar
                            </button>
                            <a
                                href="<?php echo e(route('posts.index')); ?>"
                                class="flex-1 bg-gray-200 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-300 transition-colors duration-200 font-medium text-center"
                            >
                                Limpiar
                            </a>
                        </div>
                    </form>

                    <!-- Filtros activos -->
                    <?php if(request()->hasAny(['search', 'category', 'tag'])): ?>
                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <h4 class="text-sm font-medium text-gray-700 mb-3">Filtros activos:</h4>
                            <div class="space-y-2">
                                <?php if(request('search')): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        Búsqueda: "<?php echo e(request('search')); ?>"
                                    </span>
                                <?php endif; ?>
                                <?php if(request('category')): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        <?php echo e($categories->find(request('category'))->name ?? 'Categoría'); ?>

                                    </span>
                                <?php endif; ?>
                                <?php if(request('tag')): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                        <?php echo e($tags->find(request('tag'))->name ?? 'Etiqueta'); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </aside>

            <!-- Contenido principal -->
            <main class="lg:w-3/4">
                <!-- Resultados -->
                <div class="mb-6">
                    <p class="text-gray-600">
                        Mostrando <?php echo e($posts->count()); ?> de <?php echo e($posts->total()); ?> artículos
                    </p>
                </div>

                <?php if($posts->count() > 0): ?>
                    <!-- Grid de posts -->
                    <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-8 mb-12">
                        <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <article class="bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 group">
                                <!-- Imagen -->
                                <div class="relative overflow-hidden">
                                    <?php if($post->image_path): ?>
                                        <img
                                            src="<?php echo e(Storage::url($post->image_path)); ?>"
                                            alt="<?php echo e($post->title); ?>"
                                            class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300"
                                        >
                                    <?php else: ?>
                                        <div class="w-full h-48 bg-gradient-to-br from-gray-200 to-gray-300 flex items-center justify-center">
                                            <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                        </div>
                                    <?php endif; ?>

                                    <!-- Categoría badge -->
                                    <?php if($post->category): ?>
                                        <div class="absolute top-4 left-4">
                                            <span class="bg-blue-600 text-white px-3 py-1 rounded-full text-xs font-medium">
                                                <?php echo e($post->category->name); ?>

                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <!-- Contenido -->
                                <div class="p-6">
                                    <!-- Metadatos -->
                                    <div class="flex items-center text-sm text-gray-500 mb-3">
                                        <time datetime="<?php echo e($post->created_at->format('Y-m-d')); ?>">
                                            <?php echo e($post->created_at->format('d M Y')); ?>

                                        </time>
                                        <?php if($post->user): ?>
                                            <span class="mx-2">•</span>
                                            <span><?php echo e($post->user->name); ?></span>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Título -->
                                    <h2 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-blue-600 transition-colors duration-200">
                                        <a href="<?php echo e(route('posts.show', $post)); ?>">
                                            <?php echo e($post->title); ?>

                                        </a>
                                    </h2>

                                    <!-- Excerpt -->
                                    <?php if($post->excerpt): ?>
                                        <p class="text-gray-600 mb-4 line-clamp-3">
                                            <?php echo e($post->excerpt); ?>

                                        </p>
                                    <?php endif; ?>

                                    <!-- Etiquetas -->
                                    <?php if($post->tags->count() > 0): ?>
                                        <div class="flex flex-wrap gap-2 mb-4">
                                            <?php $__currentLoopData = $post->tags->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                                    #<?php echo e($tag->name); ?>

                                                </span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($post->tags->count() > 3): ?>
                                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                                    +<?php echo e($post->tags->count() - 3); ?> más
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>

                                    <!-- Botón leer más -->
                                    <a
                                        href="<?php echo e(route('posts.show', $post)); ?>"
                                        class="inline-flex items-center text-blue-600 hover:text-blue-800 font-medium transition-colors duration-200"
                                    >
                                        Leer más
                                        <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                        </svg>
                                    </a>
                                </div>
                            </article>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Paginación -->
                    <div class="flex justify-center">
                        <?php echo e($posts->links('components.pagination')); ?>

                    </div>
                <?php else: ?>
                    <!-- Estado vacío -->
                    <div class="text-center py-12">
                        <svg class="mx-auto h-12 w-12 text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <h3 class="text-lg font-medium text-gray-900 mb-2">No se encontraron artículos</h3>
                        <p class="text-gray-500 mb-4">Intenta ajustar tus filtros de búsqueda</p>
                        <a
                            href="<?php echo e(route('posts.index')); ?>"
                            class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700"
                        >
                            Ver todos los artículos
                        </a>
                    </div>
                <?php endif; ?>
            </main>
        </div>
    </div>

    <?php $__env->startPush('css'); ?>
    <style>
        .line-clamp-3 {
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
    </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('js'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-submit del formulario cuando cambian los filtros
            const filterForm = document.querySelector('form');
            const selectElements = filterForm.querySelectorAll('select');

            selectElements.forEach(select => {
                select.addEventListener('change', function() {
                    filterForm.submit();
                });
            });

            // Animación suave para las tarjetas
            const cards = document.querySelectorAll('article');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            });

            cards.forEach(card => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                observer.observe(card);
            });
        });
    </script>
    <?php $__env->stopPush(); ?>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8c0e86a062c1c5bb6d0e151b7076f3fd)): ?>
<?php $attributes = $__attributesOriginal8c0e86a062c1c5bb6d0e151b7076f3fd; ?>
<?php unset($__attributesOriginal8c0e86a062c1c5bb6d0e151b7076f3fd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8c0e86a062c1c5bb6d0e151b7076f3fd)): ?>
<?php $component = $__componentOriginal8c0e86a062c1c5bb6d0e151b7076f3fd; ?>
<?php unset($__componentOriginal8c0e86a062c1c5bb6d0e151b7076f3fd); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\blog\resources\views/posts/index.blade.php ENDPATH**/ ?>