<x-layouts.public>
    <x-slot name="title">{{ $post->title }}</x-slot>

    <!-- Meta tags para SEO -->
    @push('meta')
        <meta name="description" content="{{ $post->excerpt ?? Str::limit(strip_tags($post->content), 160) }}">
        <meta name="keywords" content="{{ $post->tags->pluck('name')->implode(', ') }}">

        <!-- Open Graph -->
        <meta property="og:title" content="{{ $post->title }}">
        <meta property="og:description" content="{{ $post->excerpt ?? Str::limit(strip_tags($post->content), 160) }}">
        <meta property="og:type" content="article">
        <meta property="og:url" content="{{ url()->current() }}">
        @if($post->featured_image)
            <meta property="og:image" content="{{ Storage::url($post->featured_image) }}">
        @endif

        <!-- Twitter Card -->
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="{{ $post->title }}">
        <meta name="twitter:description" content="{{ $post->excerpt ?? Str::limit(strip_tags($post->content), 160) }}">
        @if($post->featured_image)
            <meta name="twitter:image" content="{{ Storage::url($post->featured_image) }}">
        @endif
    @endpush

    <!-- Breadcrumb -->
    <nav class="bg-gray-50 py-4">
        <div class="container mx-auto px-4">
            <ol class="flex items-center space-x-2 text-sm text-gray-600">
                <li>
                    <a href="{{ route('home') }}" class="hover:text-blue-600 transition-colors">
                        Inicio
                    </a>
                </li>
                <li>
                    <svg class="w-4 h-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                    </svg>
                </li>
                <li>
                    <a href="{{ route('posts.index') }}" class="hover:text-blue-600 transition-colors">
                        Blog
                    </a>
                </li>
                @if($post->category)
                    <li>
                        <svg class="w-4 h-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                        </svg>
                    </li>
                    <li>
                        <a href="{{ route('posts.index', ['category' => $post->category->id]) }}" class="hover:text-blue-600 transition-colors">
                            {{ $post->category->name }}
                        </a>
                    </li>
                @endif
                <li>
                    <svg class="w-4 h-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                    </svg>
                </li>
                <li class="text-gray-900 font-medium truncate">
                    {{ Str::limit($post->title, 50) }}
                </li>
            </ol>
        </div>
    </nav>

    <article class="py-12">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto">
                <!-- Header del artículo -->
                <header class="mb-8">
                    <!-- Categoría -->
                    @if($post->category)
                        <div class="mb-4">
                            <a
                                href="{{ route('posts.index', ['category' => $post->category->id]) }}"
                                class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800 hover:bg-blue-200 transition-colors"
                            >
                                {{ $post->category->name }}
                            </a>
                        </div>
                    @endif

                    <!-- Título -->
                    <h1 class="text-4xl md:text-5xl font-bold text-gray-900 leading-tight mb-6">
                        {{ $post->title }}
                    </h1>

                    <!-- Excerpt -->
                    @if($post->excerpt)
                        <p class="text-xl text-gray-600 leading-relaxed mb-6">
                            {{ $post->excerpt }}
                        </p>
                    @endif

                    <!-- Metadatos -->
                    <div class="flex flex-wrap items-center gap-6 text-gray-600 mb-8">
                        <!-- Autor -->
                        @if($post->user)
                            <div class="flex items-center">
                                @if($post->user->avatar)
                                    <img
                                        src="{{ Storage::url($post->user->avatar) }}"
                                        alt="{{ $post->user->name }}"
                                        class="w-10 h-10 rounded-full mr-3"
                                    >
                                @else
                                    <div class="w-10 h-10 bg-gray-300 rounded-full flex items-center justify-center mr-3">
                                        <span class="text-gray-600 font-medium text-sm">
                                            {{ substr($post->user->name, 0, 1) }}
                                        </span>
                                    </div>
                                @endif
                                <div>
                                    <p class="font-medium text-gray-900">{{ $post->user->name }}</p>
                                    <p class="text-sm text-gray-500">Autor</p>
                                </div>
                            </div>
                        @endif

                        <!-- Fecha -->
                        <div class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            <div>
                                <p class="font-medium">{{ $post->created_at->format('d M Y') }}</p>
                                <p class="text-sm text-gray-500">{{ $post->created_at->diffForHumans() }}</p>
                            </div>
                        </div>

                        <!-- Tiempo de lectura estimado -->
                        <div class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div>
                                <p class="font-medium">{{ ceil(str_word_count(strip_tags($post->content)) / 200) }} min</p>
                                <p class="text-sm text-gray-500">Lectura</p>
                            </div>
                        </div>
                    </div>

                    <!-- Botones de compartir -->
                    <div class="flex items-center gap-4 mb-8">
                        <span class="text-sm font-medium text-gray-700">Compartir:</span>
                        <div class="flex gap-2">
                            <a
                                href="https://twitter.com/intent/tweet?text={{ urlencode($post->title) }}&url={{ urlencode(url()->current()) }}"
                                target="_blank"
                                class="inline-flex items-center justify-center w-10 h-10 bg-blue-400 text-white rounded-full hover:bg-blue-500 transition-colors"
                                title="Compartir en Twitter"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                                </svg>
                            </a>
                            <a
                                href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"
                                target="_blank"
                                class="inline-flex items-center justify-center w-10 h-10 bg-blue-600 text-white rounded-full hover:bg-blue-700 transition-colors"
                                title="Compartir en Facebook"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </a>
                            <a
                                href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode(url()->current()) }}"
                                target="_blank"
                                class="inline-flex items-center justify-center w-10 h-10 bg-blue-700 text-white rounded-full hover:bg-blue-800 transition-colors"
                                title="Compartir en LinkedIn"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                                </svg>
                            </a>
                            <button
                                onclick="copyToClipboard('{{ url()->current() }}')"
                                class="inline-flex items-center justify-center w-10 h-10 bg-gray-600 text-white rounded-full hover:bg-gray-700 transition-colors"
                                title="Copiar enlace"
                            >
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                </header>

                                <!-- Imagen destacada -->
                @if($post->featured_image)
                    <div class="mb-12">
                        <img
                            src="{{ Storage::url($post->featured_image) }}"
                            alt="{{ $post->title }}"
                            class="w-full h-96 object-cover rounded-lg shadow-lg"
                        >
                    </div>
                @endif

                <!-- Contenido del artículo -->
                <div class="prose prose-lg max-w-none mb-12">
                    {!! $post->content !!}
                </div>

                <!-- Etiquetas -->
                @if($post->tags->count() > 0)
                    <div class="mb-12">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Etiquetas</h3>
                        <div class="flex flex-wrap gap-2">
                            @foreach($post->tags as $tag)
                                <a
                                    href="{{ route('posts.index', ['tag' => $tag->id]) }}"
                                    class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-100 text-gray-800 hover:bg-gray-200 transition-colors"
                                >
                                    #{{ $tag->name }}
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Navegación entre posts -->
                <div class="border-t border-b border-gray-200 py-8 mb-12">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-6">
                        <!-- Post anterior -->
                        @if($previousPost)
                            <div class="flex-1">
                                <p class="text-sm text-gray-500 mb-2">Artículo anterior</p>
                                <a
                                    href="{{ route('posts.show', $previousPost) }}"
                                    class="group flex items-center text-gray-900 hover:text-blue-600 transition-colors"
                                >
                                    <svg class="w-5 h-5 mr-2 group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                                    </svg>
                                    <div>
                                        <h4 class="font-medium line-clamp-2">{{ $previousPost->title }}</h4>
                                        <p class="text-sm text-gray-500">{{ $previousPost->created_at->format('d M Y') }}</p>
                                    </div>
                                </a>
                            </div>
                        @endif

                        <!-- Botón volver al blog -->
                        <div class="flex-shrink-0">
                            <a
                                href="{{ route('posts.index') }}"
                                class="inline-flex items-center px-4 py-2 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition-colors font-medium"
                            >
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m0 0l4-4m-4 4l4 4"></path>
                                </svg>
                                Volver al Blog
                            </a>
                        </div>

                        <!-- Post siguiente -->
                        @if($nextPost)
                            <div class="flex-1 text-right">
                                <p class="text-sm text-gray-500 mb-2">Siguiente artículo</p>
                                <a
                                    href="{{ route('posts.show', $nextPost) }}"
                                    class="group flex items-center justify-end text-gray-900 hover:text-blue-600 transition-colors"
                                >
                                    <div class="text-right">
                                        <h4 class="font-medium line-clamp-2">{{ $nextPost->title }}</h4>
                                        <p class="text-sm text-gray-500">{{ $nextPost->created_at->format('d M Y') }}</p>
                                    </div>
                                    <svg class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </a>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Información del autor -->
                @if($post->user)
                    <div class="bg-gray-50 rounded-lg p-6 mb-12">
                        <div class="flex items-start gap-4">
                            @if($post->user->avatar)
                                <img
                                    src="{{ Storage::url($post->user->avatar) }}"
                                    alt="{{ $post->user->name }}"
                                    class="w-16 h-16 rounded-full flex-shrink-0"
                                >
                            @else
                                <div class="w-16 h-16 bg-gray-300 rounded-full flex items-center justify-center flex-shrink-0">
                                    <span class="text-gray-600 font-medium text-xl">
                                        {{ substr($post->user->name, 0, 1) }}
                                    </span>
                                </div>
                            @endif
                            <div class="flex-1">
                                <h3 class="text-lg font-semibold text-gray-900 mb-1">{{ $post->user->name }}</h3>
                                @if($post->user->bio)
                                    <p class="text-gray-600 mb-3">{{ $post->user->bio }}</p>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </article>

    <!-- Posts relacionados -->
    @if($relatedPosts->count() > 0)
        <section class="bg-gray-50 py-16">
            <div class="container mx-auto px-4">
                <div class="max-w-6xl mx-auto">
                    <div class="text-center mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Artículos Relacionados</h2>
                        <p class="text-gray-600">Descubre más contenido que te puede interesar</p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                        @foreach($relatedPosts as $relatedPost)
                            <article class="bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 group">
                                <!-- Imagen -->
                                <div class="relative overflow-hidden">
                                    @if($relatedPost->featured_image)
                                        <img
                                            src="{{ Storage::url($relatedPost->featured_image) }}"
                                            alt="{{ $relatedPost->title }}"
                                            class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300"
                                        >
                                    @else
                                        <div class="w-full h-48 bg-gradient-to-br from-gray-200 to-gray-300 flex items-center justify-center">
                                            <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                        </div>
                                    @endif

                                    <!-- Categoría badge -->
                                    @if($relatedPost->category)
                                        <div class="absolute top-4 left-4">
                                            <span class="bg-blue-600 text-white px-3 py-1 rounded-full text-xs font-medium">
                                                {{ $relatedPost->category->name }}
                                            </span>
                                        </div>
                                    @endif
                                </div>

                                <!-- Contenido -->
                                <div class="p-6">
                                    <!-- Metadatos -->
                                    <div class="flex items-center text-sm text-gray-500 mb-3">
                                        <time datetime="{{ $relatedPost->created_at->format('Y-m-d') }}">
                                            {{ $relatedPost->created_at->format('d M Y') }}
                                        </time>
                                        <span class="mx-2">•</span>
                                        <span>{{ ceil(str_word_count(strip_tags($relatedPost->content)) / 200) }} min</span>
                                    </div>

                                    <!-- Título -->
                                    <h3 class="text-lg font-bold text-gray-900 mb-3 group-hover:text-blue-600 transition-colors duration-200">
                                        <a href="{{ route('posts.show', $relatedPost) }}">
                                            {{ $relatedPost->title }}
                                        </a>
                                    </h3>

                                    <!-- Excerpt -->
                                    @if($relatedPost->excerpt)
                                        <p class="text-gray-600 mb-4 line-clamp-3">
                                            {{ $relatedPost->excerpt }}
                                        </p>
                                    @endif

                                    <!-- Botón leer más -->
                                    <a
                                        href="{{ route('posts.show', $relatedPost) }}"
                                        class="inline-flex items-center text-blue-600 hover:text-blue-800 font-medium transition-colors duration-200"
                                    >
                                        Leer más
                                        <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                        </svg>
                                    </a>
                                </div>
                            </article>
                        @endforeach
                    </div>

                    <!-- Ver más posts -->
                    <div class="text-center mt-12">
                        <a
                            href="{{ route('posts.index') }}"
                            class="inline-flex items-center px-6 py-3 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition-colors duration-200"
                        >
                            Ver todos los artículos
                        </a>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endif

</x-layouts.public>
