<x-layouts.app :title="$title">
    <div class="mb-4 flex items-center justify-between align-center">
        <flux:breadcrumbs class="mb-4">
            <flux:breadcrumbs.item icon="home" :href="route('dashboard')">{{ __('Dashboard') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item :href="route('admin.tags.index')">{{ __('Tags') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item class="text-blue-500">{{ $title }}
            </flux:breadcrumbs.item>
        </flux:breadcrumbs>

    </div>

    <div class="card w-full bg-base-100 card-lg shadow-lg">
        <div class="card-body">
            <form action="{{ route('admin.tags.store') }}" method="POST">
                @csrf
                <flux:input
                    type="text"
                    name="name"
                    label="{{ __('Name') }}"
                    placeholder="{{ __('Enter tag name') }}"
                    value="{{ old('name') }}"
                />

                <div class="justify-end card-actions mt-4">
                    <button class="btn btn-primary btn-sm" type="submit">{{ __('Save') }}</button>
                    <a href="{{ route('admin.tags.index') }}" class="btn btn-secondary btn-sm">
                        {{ __('Cancel') }}
                    </a>
                </div>
            </form>
        </div>


</x-layouts.app>
