<x-layouts.app :title="$title">
    <div class="mb-4 flex items-center justify-between align-center">
        <flux:breadcrumbs>
            <flux:breadcrumbs.item icon="home" :href="route('dashboard')">{{ __('Dashboard') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item >{{ __('Posts') }}</flux:breadcrumbs.item>
        </flux:breadcrumbs>
        <a href="{{ route('admin.posts.create') }}" class="btn btn-primary btn-sm">{{ __('New Post') }}</a>
    </div>

    <div class="relative overflow-x-auto">
        <div class="card w-full bg-base-100 card-lg shadow-lg">
            <div class="card-body">
                <table class="table w-full">
                    <thead class="bg-base-200">
                        <tr>
                            <th scope="col" class="px-6 py-3">{{ __('ID') }}</th>
                            <th scope="col" class="px-6 py-3">{{ __('Title') }}</th>
                            <th scope="col" class="px-6 py-3">{{ __('Category') }}</th>
                            <th scope="col" class="px-6 py-3">{{ __('Author') }}</th>
                            <th scope="col" class="px-6 py-3">{{ __('Published At') }}</th>
                            <th scope="col" class="px-6 py-3">{{ __('Status') }}</th>
                            <th scope="col" class="px-6 py-3" width="10px">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($posts as $post)
                            <tr class="align-middle">
                                <td scope="row" class="px-6 py-3 align-middle">{{ $post->id }}</td>
                                <td scope="row" class="px-6 py-3 align-middle">{{ $post->title }}</td>
                                <td scope="row" class="px-6 py-3 align-middle">{{ $post->category->name }}</td>
                                <td scope="row" class="px-6 py-3 align-middle">{{ $post->user->name }}</td>
                                <td scope="row" class="px-6 py-3 align-middle">{{ $post->published_at ? $post->published_at->format('Y-m-d H:i') : '---' }}</td>
                                <td scope="row" class="px-6 py-3 align-middle">
                                    <span class="badge badge-sm {{ $post->is_published == '1' ? 'badge-success' : 'badge-warning' }}">
                                        {{ $post->is_published == '1' ? __('Online') : __('Offline') }}
                                    </span>
                                </td>
                                <td class="px-6 py-3 align-middle">
                                    <div class="flex items-center gap-2">
                                        <a href="{{ route('admin.posts.edit', $post) }}" class="btn btn-sm btn-primary">
                                            {{ __('Edit') }}
                                        </a>
                                        <form class="delete-form" action="{{ route('admin.posts.destroy', $post) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-error">{{ __('Delete') }}</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="mt-4">
                    {{ $posts->links() }}
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>
