<x-layouts.app :title="$title">

    @push('css')
        <link href="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css" rel="stylesheet" />
    @endpush

    <div class="mb-4 flex items-center justify-between align-center">
        <flux:breadcrumbs class="mb-4">
            <flux:breadcrumbs.item icon="home" :href="route('dashboard')">{{ __('Dashboard') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item :href="route('admin.posts.index')">{{ __('Posts') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item class="text-blue-500">{{ $title }}
            </flux:breadcrumbs.item>
        </flux:breadcrumbs>

    </div>

    <form action="{{ route('admin.posts.update', $post) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="relative overflow-hidden rounded-xl mb-2 border border-neutral-300 dark:border-neutral-700">

            <img id="imgPreview" class="w-full aspect-video object-cover object-center" src="{{ $post->image_path ? Storage::url($post->image_path) : 'https://www.caspianpolicy.org/no-image.png' }}" alt="Post Image">
            <div class="absolute top-8 right-8">
                <label for="image" class="bg-white btn cursor-pointer rounded-lg shadow-lg">{{ __('Upload Image') }}
                    <input type="file" name="image" id="image" class="hidden" accept="image/*" onchange="previewImage(event, '#imgPreview')">
                </label>
            </div>
        </div>

        <div class="card w-full bg-neutral-50 border border-neutral-300 card-lg shadow-lg space-y-4">
            <div class="card-body">
                <flux:input
                    type="text"
                    name="title"
                    label="{{ __('Title') }}"
                    placeholder="{{ __('Enter post title') }}"
                    value="{{ old('title', $post->title) }}"
                    oninput="string_to_slug(this.value, '#slug')"
                />
                <flux:input
                    type="text"
                    id="slug"
                    name="slug"
                    label="{{ __('Slug') }}"
                    placeholder="{{ __('Post slug') }}"
                    value="{{ old('slug', $post->slug) }}"
                    readonly
                />
                <flux:select name="category_id" label="{{ __('Category') }}">
                    @foreach ($categories as $category)
                        <flux:select.option
                            value="{{ $category->id }}"
                            :selected="$category->id == old('category_id', $post->category_id)">
                            {{ $category->name }}
                        </flux:select.option>
                    @endforeach
                </flux:select>

                <flux:textarea label="{{ __('Excerpt') }}" name="excerpt">{{ old('excerpt', $post->excerpt) }}</flux:textarea>
                {{-- <flux:textarea label="{{ __('Content') }}" name="content" rows="16">{{ old('content', $post->content) }}</flux:textarea> --}}
                <div>
                    <p class="text-sm font-medium mb-2">{{ __('Content') }}</p>

                        <div id="editor">{!! old('content', $post->content) !!}</div>
                        <textarea name="content" id="content" class="hidden">{{ old('content', $post->content) }}</textarea>

                </div>

                <div>
                    <p class="text-sm font-medium mb-2">{{ __('Tags') }}</p>
                    <ul class="flex flex-wrap gap-4">
                        @foreach ($tags as $tag)
                        <li>
                            <label class="label cursor-pointer">
                                <input type="checkbox" name="tags[]" class="checkbox checkbox-sm" value="{{ $tag->id }}" @checked(in_array($tag->id, old('tags', $post->tags->pluck('id')->toArray())))/>
                                <span class="label-text">{{ $tag->name }}</span>
                            </label>
                        </li>
                        @endforeach
                    </ul>
                </div>
                <div>
                    <p class="text-sm font-medium mb-2">{{ __('Status') }}</p>
                    <div class="flex gap-4">
                        <label class="label cursor-pointer">
                            <input type="radio" name="is_published" class="radio radio-sm" value="0" @checked(old('is_published', $post->is_published) == 0) />
                            <span class="label-text">{{ __('Draft') }}</span>
                        </label>
                        <label class="label cursor-pointer">
                            <input type="radio" name="is_published" class="radio radio-sm" value="1" @checked(old('is_published', $post->is_published) == 1)/>
                            <span class="label-text">{{ __('Published') }}</span>
                        </label>
                    </div>
               </div>


                <div class="justify-end card-actions">
                    <button class="btn btn-primary btn-sm" type="submit">{{ __('Update') }}</button>
                    <a href="{{ route('admin.posts.index') }}" class="btn btn-secondary btn-sm">
                        {{ __('Cancel') }}
                    </a>
                </div>
            </div>
        </div>
    </form>

    @push('js')
        <script src="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js"></script>
        <script>
        const toolbarOptions = [
            //[{ 'font': [] }],
            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
            ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
            [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
            [{ 'list': 'ordered'}, { 'list': 'bullet' }, { 'list': 'check' }],
            [{ 'align': [] }],
            [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
            [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
            //['blockquote', 'code-block'],
            ['link', 'image', 'video', 'formula'],

            //[{ 'header': 1 }, { 'header': 2 }],               // custom button values
            //[{ 'direction': 'rtl' }],                         // text direction

            // [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown


            //['clean']                                         // remove formatting button
        ];

        <!-- Initialize Quill editor -->

        const quill = new Quill('#editor', {
            modules: {
                toolbar: toolbarOptions
            },
            theme: 'snow'
        });

        quill.on('text-change', function(delta, oldDelta, source) {
            document.querySelector('#content').value = quill.root.innerHTML;
        });
        </script>
    @endpush

</x-layouts.app>
