<x-layouts.app :title="$title">
    <div class="mb-4 flex items-center justify-between align-center">
        <flux:breadcrumbs class="mb-4">
            <flux:breadcrumbs.item icon="home" :href="route('dashboard')">{{ __('Dashboard') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item :href="route('admin.posts.index')">{{ __('Posts') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item class="text-blue-500">{{ $title }}
            </flux:breadcrumbs.item>
        </flux:breadcrumbs>

    </div>
    <form action="{{ route('admin.posts.store') }}" method="POST" class="space-y-4">
        @csrf

        <div class="card w-full bg-neutral-50 border border-neutral-300 card-lg shadow-lg space-y-4">
            <div class="card-body">
                    <flux:input
                        type="text"
                        name="title"
                        label="{{ __('Title') }}"
                        placeholder="{{ __('Enter post title') }}"
                        value="{{ old('title') }}"
                        oninput="string_to_slug(this.value, '#slug')"
                    />
                    <flux:input
                        type="text"
                        id="slug"
                        name="slug"
                        label="{{ __('Slug') }}"
                        placeholder="{{ __('Post slug') }}"
                        value="{{ old('slug') }}"
                        readonly
                    />
                    <flux:select name="category_id" label="{{ __('Category') }}">
                        @foreach ($categories as $category)
                            <flux:select.option
                                value="{{ $category->id }}"
                                :selected="$category->id == old('category_id')">
                                {{ $category->name }}
                            </flux:select.option>
                        @endforeach
                    </flux:select>


                <div class="justify-end card-actions">
                    <button class="btn btn-primary btn-sm" type="submit">{{ __('Save') }}</button>
                    <a href="{{ route('admin.posts.index') }}" class="btn btn-secondary btn-sm">
                        {{ __('Cancel') }}
                    </a>
                </div>
            </div>
        </div>
    </form>
</x-layouts.app>
