<x-layouts.app :title="$title">
    <div class="mb-4 flex items-center justify-between align-center">
        <flux:breadcrumbs>
            <flux:breadcrumbs.item icon="home" :href="route('dashboard')">{{ __('Dashboard') }}</flux:breadcrumbs.item>
            <flux:breadcrumbs.item >{{ __('Categories') }}</flux:breadcrumbs.item>
        </flux:breadcrumbs>
        <a href="{{ route('admin.categories.create') }}" class="btn btn-primary btn-sm">{{ __('New Category') }}</a>
    </div>

    <div class="relative overflow-x-auto">
        <div class="card w-full bg-base-100 card-lg shadow-lg">
            <div class="card-body">
                <table class="table w-full">
                    <thead class="bg-base-200">
                        <tr>
                            <th scope="col" class="px-6 py-3">{{ __('ID') }}</th>
                            <th scope="col" class="px-6 py-3">{{ __('Name') }}</th>
                            <th scope="col" class="px-6 py-3" width="10px">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($categories as $category)
                            <tr class="align-middle">
                                <td scope="row" class="px-6 py-3 align-middle">{{ $category->id }}</td>
                                <td scope="row" class="px-6 py-3 align-middle">{{ $category->name }}</td>
                                <td class="px-6 py-3 align-middle">
                                    <div class="flex items-center gap-2">
                                        <a href="{{ route('admin.categories.edit', $category) }}" class="btn btn-sm btn-primary">
                                            {{ __('Edit') }}
                                        </a>
                                        <form class="delete-form" action="{{ route('admin.categories.destroy', $category) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-error">{{ __('Delete') }}</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</x-layouts.app>
