<?php

namespace App\Observers;

use App\Models\Post;

class PostObserver
{
    public function updating(Post $post)
    {
        // Update the published_at timestamp only if the post is published and doesn't have a published_at date
        if ($post->is_published && is_null($post->getOriginal('published_at'))) {
            $post->published_at = now();
        } elseif (!$post->is_published) {
            $post->published_at = null;
        }
    }
}
