<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Post;
use App\Models\Tag;
use Illuminate\Http\Request;

class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $query = Post::with(['category', 'tags', 'user'])
            ->where('is_published', true)
            ->orderBy('created_at', 'desc');

        // Filtro por categoría
        if ($request->filled('category')) {
            $query->where('category_id', $request->category);
        }

        // Filtro por etiqueta
        if ($request->filled('tag')) {
            $query->whereHas('tags', function ($q) use ($request) {
                $q->where('tags.id', $request->tag);
            });
        }

        // Filtro por búsqueda
        if ($request->filled('search')) {
            $query->where(function ($q) use ($request) {
                $q->where('title', 'like', '%' . $request->search . '%')
                    ->orWhere('excerpt', 'like', '%' . $request->search . '%');
            });
        }

        $posts = $query->paginate(9)->withQueryString();
        $categories = Category::withCount('posts')->get();
        $tags = Tag::withCount('posts')->get();

        return view('posts.index', compact('posts', 'categories', 'tags'));
    }



    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Post $post)
    {
        // Check if the post is published
        if (!$post->is_published) {
            abort(404);
        }
        // Get previous and next posts
        // Ensure the post is loaded with necessary relationships
        $post->load(['category', 'tags', 'user']);
        // Get previous and next posts
        $previousPost = Post::where('id', '<', $post->id)->orderBy('id', 'desc')->first();
        $nextPost = Post::where('id', '>', $post->id)->orderBy('id', 'asc')->first();
        $post->load(['category', 'tags', 'user']);
        $post->increment('views_count'); // Increment views count
        $post->loadCount('comments'); // Load comments count
        $post->load(['comments' => function ($query) {
            $query->where('is_approved', true)->orderBy('created_at', 'desc');
        }]);
        $post->load(['comments.user', 'user']);
        $post->load(['comments.replies' => function ($query) {
            $query->where('is_approved', true)->orderBy('created_at', 'desc');
        }]);




        return view('posts.show', compact('post'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Post $post)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Post $post)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Post $post)
    {
        //
    }
}
