<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Tag;
use Illuminate\Http\Request;

class TagController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = __('Tags');
        $tags = Tag::all();
        return view('admin.tags.index', compact('title', 'tags'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = __('Create Tag');
        return view('admin.tags.create', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|min:3|max:255|unique:tags,name',
        ]);
        Tag::create($data);

        session()->flash('swal', [
            'icon' => 'success',
            'title' => __('Success'),
            'text' => __('Tag created successfully.'),
            'timer' => 2500,
            'showConfirmButton' => false,
        ]);

        return redirect()->route('admin.tags.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(Tag $tag)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Tag $tag)
    {
        $title = __('Edit Tag');
        return view('admin.tags.edit', compact('tag', 'title'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Tag $tag)
    {
        $data = $request->validate([
            'name' => 'required|string|min:3|max:255|unique:tags,name,' . $tag->id,
        ]);
        $tag->update($data);

        session()->flash('swal', [
            'icon' => 'success',
            'title' => __('Success'),
            'text' => __('Tag updated successfully.'),
            'timer' => 2500,
            'showConfirmButton' => false,
        ]);

        return redirect()->route('admin.tags.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Tag $tag)
    {
        $tag->delete();

        session()->flash('swal', [
            'icon' => 'success',
            'title' => __('Success'),
            'text' => __('Tag deleted successfully.'),
            'timer' => 2500,
            'showConfirmButton' => false,
        ]);
        return redirect()->route('admin.tags.index');
    }
}
