<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = __('Categories');
        $categories = Category::orderBy('id', 'desc')->get();
        return view('admin.categories.index', compact('categories', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = __('Create Category');
        return view('admin.categories.create', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|min:3|max:255',
        ]);
        Category::create($data);

        session()->flash('swal', [
            'icon' => 'success',
            'title' => __('Success'),
            'text' => __('Category created successfully.'),
            'timer' => 2500,
            'showConfirmButton' => false,
        ]);

        return redirect()->route('admin.categories.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(Category $category) {}

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Category $category)
    {
        $title = __('Edit Category');
        return view('admin.categories.edit', compact('category', 'title'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Category $category)
    {
        $data = $request->validate([
            'name' => 'required|string|min:3|max:255',
        ]);
        $category->update($data);

        session()->flash('swal', [
            'icon' => 'success',
            'title' => __('Success'),
            'text' => __('Category updated successfully.'),
            'timer' => 2500,
            'showConfirmButton' => false,
        ]);

        return redirect()->route('admin.categories.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Category $category)
    {
        $category->delete();

        session()->flash('swal', [
            'icon' => 'success',
            'title' => __('Success'),
            'text' => __('Category deleted successfully.'),
            'timer' => 2500,
            'showConfirmButton' => false,
        ]);
        return redirect()->route('admin.categories.index');
    }
}
